<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Slider Widget.
 *
 */
class Tourm_Banners extends Widget_Base {

	public function get_name() {
		return 'tourmbanners22';
	}
	public function get_title() {
		return __( 'Banner Slider 2', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'banner_section',
			[
				'label' 	=> __( 'Banner Slider', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', ['Style One', 'Style Two', 'Style Three'] ); 

		tourm_media_fields($this, 'bg', 'Background Image', ['3'] );
		tourm_media_fields($this, 'overlay_shape', 'Overlay Shape', ['1'] );
		tourm_general_fields($this, 'shadow_text', 'Shadow Text', 'TEXT', 'GYM', ['1']);

		tourm_media_fields($this, 'prev', 'Choose Previous Arrow Image', ['2', '3'] );
		tourm_media_fields($this, 'next', 'Choose Next Arrow Image', ['2', '3'] );

		$repeater = new Repeater();

		tourm_media_fields($repeater, 'bg', 'Choose Background');
		tourm_media_fields($repeater, 'image', 'Choose Image');
		tourm_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Welcome To Fitkit');
		tourm_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'We offer home');
		tourm_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', '');
		tourm_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Our All Services');
		tourm_url_fields($repeater, 'button_url', 'Button URL');

		tourm_general_fields($repeater, 'counter_num', 'Counter Numaber', 'TEXTAREA2', '2k');
		tourm_general_fields($repeater, 'counter_title', 'Counter Title', 'TEXTAREA2', 'Satisfied Customer');
		
		$this->add_control(
			'banner_slides',
			[
				'label' 		=> __( 'Banners', 'tourm' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'We offer home', 'tourm' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$repeater = new Repeater();

		tourm_media_fields($repeater, 'bg', 'Choose Background');
		tourm_media_fields($repeater, 'image', 'Choose Image');
		tourm_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Welcome To Fitkit');
		tourm_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'We offer home');
		tourm_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', '');
		tourm_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Our All Services');
		tourm_url_fields($repeater, 'button_url', 'Button URL');
		tourm_general_fields($repeater, 'button_text2', 'Button 2 Text', 'TEXT', 'Contact Us');
		tourm_url_fields($repeater, 'button_url2', 'Button 2 URL');
		
		$this->add_control(
			'banner_slides2',
			[
				'label' 		=> __( 'Banners', 'tourm' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'We offer home', 'tourm' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		$repeater = new Repeater();

		tourm_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Welcome To Fitkit');
		tourm_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'We offer home');
		tourm_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Our All Services');
		tourm_url_fields($repeater, 'button_url', 'Button URL');
		tourm_general_fields($repeater, 'button_text2', 'Button 2 Text', 'TEXT', 'Contact Us');
		tourm_url_fields($repeater, 'button_url2', 'Button 2 URL');
		
		$this->add_control(
			'banner_slides3',
			[
				'label' 		=> __( 'Banners', 'tourm' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'We offer home', 'tourm' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
		);


		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		tourm_common_style_fields( $this, '01', 'Subtitle', '{{WRAPPER}} .sub-title', ['1', '2', '3'],'--theme-color' );
		tourm_common_style_fields( $this, '02', 'Title', '{{WRAPPER}} .hero-title' );
		tourm_common_style_fields( $this, '03', 'Description', '{{WRAPPER}} .hero-text', ['1', '2'] );

		tourm_common_style_fields( $this, '04', 'Counter Number', '{{WRAPPER}} .counter-number-wrap', ['1'] );
		tourm_common_style_fields( $this, '05', 'Counter Text', '{{WRAPPER}} .counter-title', ['1']  );

		//------Button Style-------
		tourm_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th_btn', ['1', '2', '3'] );
		tourm_button_style_fields( $this, '11', 'Button 2 Styling', '{{WRAPPER}} .th_btn2', ['2', '3'] );

    }

	protected function render() {

    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="th-hero-wrapper hero-1" id="hero">';
				echo '<div class=">';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['banner_slides'] as $key => $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="hero-inner" data-bg-src="'.esc_url( $data['bg']['url'] ).'" data-overlay="black" data-opacity="9">';
									echo '<div class="container">';
										echo '<div class="row">';
											echo '<div class="col-xl-8 col-lg-6">';
												echo '<div class="hero-style1">';
													if(!empty($data['subtitle'])){
														echo '<span class="sub-title text-theme after-none" data-ani="slideinup" data-ani-delay="0.2s">'.esc_html($data['subtitle']).'</span>';
													}
													if(!empty($data['title'])){
														echo '<h1 class="hero-title">'.wp_kses_post($data['title']).'</h1>';
													}
													if(!empty($data['desc'])){
														echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.5s">'.esc_html($data['desc']).'</p>';
													}
													echo '<div class="btn-wrap" data-ani="slideinup" data-ani-delay="0.7s">';
														if(!empty($data['button_text'])){
															echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn th_btn"">'.esc_html($data['button_text']).'</a>';
														}
														echo '<div class="hero-counter-wrap">';
															if(!empty($data['counter_num'])){
																echo '<div class="counter-number-wrap">'.wp_kses_post($data['counter_num']).'</div>';
															}
															if(!empty($data['counter_title'])){
																echo '<h4 class="counter-title">'.esc_html($data['counter_title']).'</h4>';
															}
														echo '</div>';
													echo '</div>';
												echo '</div>';
											echo '</div>';
											echo '<div class="col-xl-4 col-lg-6 align-self-end">';
												if($data['image']['url'] ){
												echo '<div class="hero-img1" data-ani="slideinright" data-ani-delay="0.5s">';
													echo tourm_img_tag( array(
														'url'   => esc_url( $data['image']['url'] ),
													)); 
												echo '</div>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
									if(!empty($settings['shadow_text'])){
										echo '<div class="hero-shadow-text">'.esc_html($settings['shadow_text']).'</div>';
									}
									if($settings['overlay_shape']['url'] ){
										echo '<div class="hero-bg-shape1" data-bg-src="'.esc_url( $settings['overlay_shape']['url'] ).'">';
									}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<div class="icon-box">';
						echo '<button data-slider-prev="#heroSlider1" class="slider-arrow slider-prev"><span class="icon"></span></button>';
						echo '<button data-slider-next="#heroSlider1" class="slider-arrow slider-next"><span class="icon"></span></button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="th-hero-wrapper hero-2" id="hero">';
				echo '<div class="swiper th-slider" id="heroSlider2" data-slider-options=\'{"effect":"fade"}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['banner_slides2'] as  $data ){
							echo '<div class="swiper-slide" data-bg-src="'.esc_url( $data['bg']['url'] ).'">';
								echo '<div class="hero-inner">';
									echo '<div class="container">';
										echo '<div class="hero-style2">';
											if(!empty($data['subtitle'])){
												echo '<span class="sub-title after-none" data-ani="slideinup" data-ani-delay="0.2s">'.esc_html($data['subtitle']).'</span>';
											}
											if(!empty($data['title'])){
												echo '<h1 class="hero-title">'.wp_kses_post($data['title']).'</h1>';
											}
											if(!empty($data['desc'])){
												echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['desc']).'</p>';
											}
											echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.7s">';
												if(!empty($data['button_text'])){
													echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style-radius th_btn"">'.esc_html($data['button_text']).'</a>';
												}
												if(!empty($data['button_text2'])){
													echo '<a href="'.esc_url( $data['button_url2']['url'] ).'" class="th-btn style-border style-radius th_btn2"">'.esc_html($data['button_text2']).'</a>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
									if($data['image']['url'] ){
										echo '<div class="hero-img z-index-common" data-ani="slidebottomright" data-ani-delay="0.1s">';
											echo tourm_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											)); 
										echo '</div>';
									}
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<div class="icon-box">';
						echo '<button data-slider-prev="#heroSlider2" class="slider-arrow slider-prev">';
							echo tourm_img_tag( array(
								'url'   => esc_url( $settings['prev']['url'] ),
							)); 
						echo '</button>';
						echo '<button data-slider-next="#heroSlider2" class="slider-arrow slider-next">';
							echo tourm_img_tag( array(
								'url'   => esc_url( $settings['next']['url'] ),
							)); 
						echo '</button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
			
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="th-hero-wrapper hero-3" id="hero" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
				echo '<div class="swiper th-slider" id="heroSlider3" data-slider-options=\'{"effect":"fade", "autoHeight": "true"}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['banner_slides3'] as  $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="hero-inner">';
									echo '<div class="container">';
										echo '<div class="hero-style3">';
											if(!empty($data['subtitle'])){
												echo '<span class="sub-title" data-ani="slideinup" data-ani-delay="0.2s">'.esc_html($data['subtitle']).'</span>';
											}
											if(!empty($data['title'])){
												echo '<h1 class="hero-title">'.wp_kses_post($data['title']).'</h1>';
											}
											echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.7s">';
												if(!empty($data['button_text'])){
													echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style-radius th_btn"">'.esc_html($data['button_text']).'</a>';
												}
												if(!empty($data['button_text2'])){
													echo '<a href="'.esc_url( $data['button_url2']['url'] ).'" class="th-btn style-border style-radius th_btn2"">'.esc_html($data['button_text2']).'</a>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<div class="icon-box">';
						echo '<button data-slider-prev="#heroSlider3" class="slider-arrow slider-prev">';
							echo tourm_img_tag( array(
								'url'   => esc_url( $settings['prev']['url'] ),
							)); 
						echo '</button>';
						echo '<button data-slider-next="#heroSlider3" class="slider-arrow slider-next">';
							echo tourm_img_tag( array(
								'url'   => esc_url( $settings['next']['url'] ),
							)); 
						echo '</button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}

		
	}

} 