<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Slider Widget.
 *
 */
class Tourm_Banner1 extends Widget_Base {

	public function get_name() {
		return 'tourmbanner1331';
	}
	public function get_title() {
		return __( 'Banner Slider 02', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'banner_section',
			[
				'label' 	=> __( 'Banner', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] );


		$fields_to_include = [ 'image' => ['Background'], 'title' => ['Title', 'Subtitle'], 'btn' => ['Button Text 1', 'Button Text 2'], 'url' => ['Button URL 1', 'Button URL 2'] ];
		tourm_repeater_fields( $this, 'banners1', 'Banner Info', $fields_to_include, ['1'] );


		tourm_media_fields( $this, 'bg', 'Bg Image', ['2'] );

		$fields_to_include2 = [ 'title' => ['Title', 'Description', 'Video url'] , 'btn' => ['Button Text'], 'url' => ['Button URL']] ;
		tourm_repeater_fields( $this, 'banners2', 'Banner Info', $fields_to_include2, ['2'] );

		$fields_to_include3 = [ 'image' => ['Image'], 'title' => ['Title', 'Price', 'Day'] , 'btn' => ['Button Text'], 'url' => ['Button URL']] ;
		tourm_repeater_fields( $this, 'banners3', 'Banner Info', $fields_to_include3, ['2'] );

		$fields_to_include4 = [ 'image' => ['Image'], 'title' => ['Title', 'Description'] , 'btn' => ['Button Text'], 'url' => ['Button URL']] ;
		tourm_repeater_fields( $this, 'banners4', 'Banner Info', $fields_to_include4, ['3'] );

		// tourm_general_fields( $this, 'id', 'Scroll ID', 'TEXT', 'about-sec', ['2','3'] );

		tourm_general_fields( $this, 'ids', 'Scroll ID', 'TEXT', 'About', ['2','3'] );


		$this->end_controls_section();


		tourm_common_style_fields($this, 'subtitle', 'Subtitle', '{{WRAPPER}} .banner_subtitle', ['1']);

		//-------Title Style-------
		tourm_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .banner_title', ['1']);
		tourm_button_style_fields($this, '10', 'Button Styling', '{{WRAPPER}} .th-btn .style2', ['1']);
		tourm_button_style_fields($this, '11', 'Button Styling', '{{WRAPPER}} .th-btn', ['1']);

    }

	protected function render() {

    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="th-hero-wrapper hero-1" id="hero">';
		        echo '<div class="swiper th-slider hero-slider-1" id="heroSlide1" data-slider-options=\'{"effect":"fade","menu": ["", "", ""],"heroSlide1": {"swiper-container": {"pagination": {"el": ".swiper-pagination", "clickable": true }}}}\'>';
		            echo '<div class="swiper-wrapper">';
		               	foreach( $settings['banners1'] as  $data ){ 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';

			                    	if(!empty(  $data['background']['url'] )){
	                                    echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['background']['url']  ).'"></div>';
	                                }
			                        echo '<div class="container">';
			                            echo '<div class="hero-style1">';
			                            	if(!empty($data['title'])){
				                                echo '<span class="sub-title style1 banner_title" data-ani="slideinup" data-ani-delay="0.2s">'.esc_html($data['title']).'</span>';
				                            }
				                            if(!empty($data['subtitle'])){
				                                echo '<h1 class="hero-title banner_subtitle" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html($data['subtitle']).'</h1>';
				                            }
			                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">';
			                                	if(!empty($data['button_text_1'])){  
				                                    echo '<a href="'.esc_url( $data['button_url_1']['url'] ).'" class="th-btn th-icon">'.esc_html($data['button_text_1']).'</a>';
				                                }
				                                if(!empty($data['button_text_2'])){  
				                                    echo '<a href="'.esc_url( $data['button_url_2']['url'] ).'" class="th-btn style2 th-icon">'.esc_html($data['button_text_2']).'</a>';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		            echo '<div class="th-swiper-custom">';
		                echo '<button data-slider-prev="#heroSlide1" class="slider-arrow slider-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow.svg" alt=""></button>';
		                echo '<div class="slider-pagination"></div>';
		                echo '<button data-slider-next="#heroSlide1" class="slider-arrow slider-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow.svg" alt=""></button>';
		            echo '</div>';

		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			$bg = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';

			echo '<div class="hero-2" id="hero">';
		        echo '<div class="hero2-overlay" data-bg-src="'.esc_url( $bg ).'"></div>';
		        echo '<div class="swiper hero-slider-2" id="heroSlide2">';
		            echo '<div class="swiper-wrapper">';

		            	foreach( $settings['banners2'] as  $data ){ 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                    	if(!empty( $data['video_url'] )){
				                        echo '<video autoplay loop muted>';
				                            echo '<source src="'.esc_url( $data['video_url'] ).'" type="video/mp4">';
				                        echo '</video>';
				                    }
			                        echo '<div class="container">';
			                            echo '<div class="hero-style2">';
			                            	if(!empty( $data['title'] )){
				                                echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">'.wp_kses_post( $data['title'] ).'</h1>';
				                            }
				                            if(!empty( $data['description'] )){
				                                echo '<p class="hero-desc" data-ani="slideinup" data-ani-delay="0.5s">'.esc_html( $data['description'] ).'</p>';
				                            }
				                            if(!empty($data['button_text'])){  
				                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">';
				                                    echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn white-btn th-icon">'.esc_html($data['button_text']).'</a>';
				                                echo '</div>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		            echo '<div class="th-swiper-custom">';
		                echo '<div class="swiper-pagination"></div>';
		                echo '<div class="hero-icon">';
		                    echo '<button data-slider-prev="#heroSlide2, #heroSlide3" class="hero-arrow slider-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-left.svg" alt=""></button>';
		                    echo '<button data-slider-next="#heroSlide2, #heroSlide3" class="hero-arrow slider-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-right.svg" alt=""></button>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="swiper heroThumbs" id="heroSlide3">';
		            echo '<div class="swiper-wrapper">';

		            	foreach( $settings['banners3'] as  $data ){ 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                        echo '<div class="hero-card">';
			                        	if(!empty(  $data['image']['url'] )){
				                            echo '<div class="hero-img">';
				                                echo '<img src="'.esc_url( $data['image']['url'] ).'" alt="">';
				                            echo '</div>';
				                        }
			                            echo '<div class="hero-card_content">';
			                            	if(!empty( $data['title'] )){
				                                echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
				                            }
				                            if(!empty( $data['price'] )){
				                                echo '<h4 class="hero-card_price">'.wp_kses_post( $data['price'] ).'</h4>';
				                            }
				                            if(!empty( $data['day'] )){
				                                echo '<span><i class="fa-light fa-clock"></i>'.esc_html( $data['day'] ).'</span>';
				                            }
				                            if(!empty($data['button_text'])){  
				                                echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2">'.esc_html($data['button_text']).'</a>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		        if( !empty( $settings['ids'] ) ){
			        echo '<div class="scroll-down">';
			            echo '<a href="'.esc_url( $settings['ids'] ).'" class="scroll-wrap"><span><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/down-arrow.svg" alt=""></span>Scroll Down</a>';
			        echo '</div>';
			    }
		    echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="hero-3" id="hero">';
		        echo '<div class="swiper hero-slider-3" id="heroSlide3">';
		            echo '<div class="swiper-wrapper">';


		            	foreach( $settings['banners4'] as  $data ){ 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                    	if(!empty(  $data['image']['url'] )){
				                        echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['image']['url'] ).'"></div>';
				                    }
			                        
			                        echo '<div class="container">';
			                            echo '<div class="hero-style3">';
			                            	if(!empty( $data['title'] )){
				                                echo '<h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.2s">'.esc_html( $data['title'] ).'</h1>';
				                            }
				                            if(!empty( $data['description'] )){
				                                echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.4s">'.esc_html( $data['description'] ).'</p>';
				                            }
				                            if(!empty($data['button_text'])){  
				                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">';
				                                    echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2 th-icon">'.esc_html($data['button_text']).'</a>';
				                                echo '</div>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		                


		            echo '</div>';

		        echo '</div>';
		        echo '<div class="hero3-wrapper">';
		            echo '<div class="container">';
		                echo '<div class="row justify-content-center align-items-end flex-row-reverse">';
		                    echo '<div class="col-lg-4">';
		                        echo '<div class="hero3-swiper-custom">';
		                            echo '<button data-slider-prev="#heroSlide3" class="swiper-button-next">';
		                                echo '<img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-right.svg" alt=""></button>';
		                            echo '<div class="swiper-pagination"></div>';
		                            echo '<button data-slider-next="#heroSlide3" class="swiper-button-prev">';
		                                echo '<img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-left.svg" alt=""></button>';

		                        echo '</div>';
		                        echo '<div class="swiper hero3Thumbs">';
		                            echo '<div class="swiper-wrapper">';

		                            	foreach( $settings['banners4'] as  $data ){ 
			                                echo '<div class="swiper-slide">';
			                                    echo '<div class="hero-inner">';
			                                        echo '<div class="hero3-card">';
			                                        	if(!empty(  $data['image']['url'] )){
				                                            echo '<div class="hero-img">';
				                                                echo '<img src="'.esc_url( $data['image']['url'] ).'" alt="">';
				                                            echo '</div>';
				                                        }
			                                        echo '</div>';
			                                    echo '</div>';
			                                echo '</div>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="col-lg-8">';
		                        echo '<div class="hero-booking">';
		                            echo do_shortcode( '[Wte_Advanced_Search_Form]' ); 
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        if( !empty( $settings['ids'] ) ){
			        echo '<div class="scroll-down">';
			            echo '<a href="'.esc_url( $settings['ids'] ).'" class="scroll-wrap"><span><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/down-arrow.svg" alt=""></span> Scroll Down</a>';
			        echo '</div>';
			    }
		    echo '</div>';
		}
	}
}