<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Tour Category Widget .
 *
 */
class tourm_Tour_Category extends Widget_Base {

	public function get_name() {
		return 'tourmcatlist';
	}
	public function get_title() {
		return __( 'Tour Categories', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Tour Categories', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two', 'Style Three', 'Style Four'] );


		$fields_to_include = [ 'image' => ['Thumb Image'], 'title' => ['Title'],'btn' => ['Button Text'], 'url' => ['URL'] ];
		tourm_repeater_fields( $this, 'cat_list', 'Tour Category Lists', $fields_to_include, ['1','2','3','4'] );


        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start

		tourm_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .title a', ['1','2','3','4'] );
		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="swiper categorySlider" id="categorySlide">';
                echo '<div class="swiper-wrapper">';

                    foreach( $settings['cat_list'] as $data ){
	                    echo '<div class="swiper-slide">';
	                        echo '<div class="category-card single">';
	                        	if(!empty($data['thumb_image']['url'])){
		                            echo '<div class="box-img global-img">';
		                                echo tourm_img_tag( array(
											'url'   => esc_url( $data['thumb_image']['url'] ),
										));
		                            echo '</div>';
		                        }
		                        if(!empty($data['title'])){
		                            echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                        }
	                            echo '<a class="line-btn" href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['button_text']).'</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
                echo '<div class="swiper-pagination"></div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="swiper categorySlider2" id="categorySlide2">';
                echo '<div class="swiper-wrapper">';
                    foreach( $settings['cat_list'] as $data ){
	                    echo '<div class="swiper-slide">';
	                        echo '<div class="category-card single2">';
	                        	if(!empty($data['thumb_image']['url'])){
		                            echo '<div class="box-img global-img">';
		                                echo tourm_img_tag( array(
											'url'   => esc_url( $data['thumb_image']['url'] ),
										));
		                            echo '</div>';
		                        }
		                        if(!empty($data['title'])){
		                            echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                        }
	                            echo '<a class="line-btn" href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['button_text']).'</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
                echo '<div class="swiper-pagination"></div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow category-slider3" id="categorySlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"5"}}}\'>
                    <div class="swiper-wrapper">';
                        foreach( $settings['cat_list'] as $data ){
		                    echo '<div class="swiper-slide">';
		                        echo '<div class="category-card single2">';
		                        	if(!empty($data['thumb_image']['url'])){
			                            echo '<div class="box-img global-img">';
			                                echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
			                            echo '</div>';
			                        }
			                        if(!empty($data['title'])){
			                            echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
			                        }
		                            echo '<a class="line-btn" href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['button_text']).'</a>';
		                        echo '</div>';
		                    echo '</div>';
		                }
                    echo '</div>';
                    echo '<div class="slider-pagination"></div>';
                echo '</div>';
            echo '</div>';
		}else{
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow categorySlider4" id="categorySlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"5"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                    	foreach( $settings['cat_list'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="category-card style3">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="box-img global-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                if(!empty($data['title'])){
			                            echo '<h3 class="box-title title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
			                        }
	                                echo '<a class="line-btn" href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['button_text']).'</a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                    echo '<div class="slider-pagination"></div>';
                echo '</div>';
            echo '</div>';
		}
	}
}